/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

//	AlignPlanes.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cAssembly.h"
#include "cApplication.h"


HRESULT AlignPlanes(IDesign *design, IGeometric *pFirstGeometric, IGeometric *pSecondGeometric, double offset, CString name)
{

	//  Aligns one face of component(pFirstGeometric) with the face(pSecondGeometric)
	//	of the second component

	START_METHOD("Align Planes")

	HRESULT status = CONV_SUCCESS;
	
	VARIANT_BOOL bVal;
		
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IObject *object1 = NULL;
	IObject *object2 = NULL;

	VARIANT_BOOL blnFirstGeometric;
	VARIANT_BOOL blnSecondGeometric;

	// check for first geometric
	CHECK_VAR_STATUS(pFirstGeometric)

	object1 = CAST(IObject, pFirstGeometric);
	status = object1->IsA(GetBSTR("Geometric"),&blnFirstGeometric);
	CHECK_RETURN_STATUS(status)

	// check for second geometric
	CHECK_VAR_STATUS(pSecondGeometric)
	
	object2 = CAST(IObject, pSecondGeometric);

	status = object2->IsA(GetBSTR("Geometric"),&blnSecondGeometric);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *pActiveDoc = NULL;

	// if both the GeometricClass is not NULL
	CHECK_VAR_STATUS(blnFirstGeometric);
	CHECK_VAR_STATUS(blnSecondGeometric);

	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)
	
	IGeometric *geometric=NULL;

	geometric = CAST(IGeometric, pSecondGeometric);

	IGeometric *pTemp = NULL;

	// UpdateDependencies method
	if (geometric->IsDependentOn(CAST(IGeometric,pFirstGeometric),&bVal)) {
		pTemp = pFirstGeometric;
		pFirstGeometric = pSecondGeometric;
		pSecondGeometric = pTemp;
	}

	IObject *pIns = NULL;
	status = object1->GetParent(GetBSTR("DesignInstance"),&pIns);
	CHECK_RETURN_STATUS(status)

	IAbutPlanes *pMatingCondition = NULL;
	
	VARIANT_BOOL reversed = FALSE;
	status = (GetCLASS(AbutPlanes))->CreateAbutPlanes(design, CAST(IGeometric, pFirstGeometric), CAST(IGeometric, pSecondGeometric), offset, reversed, name.AllocSysString(), &pMatingCondition);
	CHECK_RETURN_STATUS(status)
 	
	IDesignInstance *ins = CAST(IDesignInstance, pIns);
		
	status = ins->AddMatingCondition(CAST(IMatingCondition,pMatingCondition));
	CHECK_RETURN_STATUS(status)

	END_METHOD("Align Planes")
}
